import OOPLS.PostalRecord;
import OOPLS.RadixSorter;
import java.util.LinkedList;
public class RadixSortTester {
    static String[][] trialData = {
        {"Zachariah Malachi", "101 Holy Lane", 
         "Apartment 3B", "Jerusalem", "GA", "35109"},
        {"Cody Kadiddlehopper", "5967 Old Horse Lane", 
         "", "Badlands", "KS", "50505"},
        {"Curtis Plemmons", "Route 7", 
         "", "Turkey Trot", "PA", "16678"},
        {"Melinda Jabbers", "11234 Fifth Avenue", "", 
         "Manhattan", "OK", "77789"},
        {"Smyrna Figs", "200 Locust Avenue", "", 
         "Richmond", "KY", "40475"},
        {"Allyson Krauts", "421 Mockingbird Lane", 
         "Box 277", "Nashville", "TN", "37205"}
    };
    public static void main(String[] arg) {
        LinkedList mainQueue = new LinkedList();
        try {
            for (int i=0; i<trialData.length; ++i) {
                mainQueue.add(new PostalRecord(
                    trialData[i][0], trialData[i][1], 
                    trialData[i][2], trialData[i][3], 
                    trialData[i][4], trialData[i][5]
                ));
            }
            RadixSorter.sort(mainQueue);
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        while (!mainQueue.isEmpty()) {
            PostalRecord record = 
                (PostalRecord)mainQueue.element();
            if (record != null) {
                System.out.println(record.zip);
                mainQueue.remove();
            }
        }
    }
}
